  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_BindingWritingPermissions.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "stdio.h"
#include "SST_SEP_TST.h"
#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "SEP_ATP_UTIL_funcs.h"

/************************ Global Data **************************/
extern TST_ATP_BindingWritingPermissionsStruct* TST_ATP_BindingWritingPermissionsTestData;
extern DxUint8_t*    GlobalMemBuff;
extern DxUint8_t*    CurrGlobalMemBuff;
/************************ Public Functions ***********************************/
/*****************************************************************************
* Function Name:
*  SEPQA_SST_BindingWritingPermissions
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the bind and unbind authenticator to data object capabilities of the SST
* NOTE: this is a test that has error return values as a correct matter or operation!
*  
* Algorithm:
*    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
*    2.  Create a new session  session#1 by calling: SST_SessionCreate.
*    3.  Create a new session  session#2 by calling: SST_SessionCreate.
*    4.  Create a new session  session#3 by calling: SST_SessionCreate.
*    5.  Open a transaction by calling: SST_TransactionStart.
*    6.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    7.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyRSACreate. 
*    8.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorAESSharedSecretCreate.
*    9.  Open the public key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_RSA_PSS_Sign
*            iii. SST_AuthenticationOpen.
*    10. Close the transaction by calling: SST_TransactionClose.
*    11. Open a transaction by calling: SST_TransactionStart.
*    12. Open the AES shared key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_AES (Encrypt the challenge using the AES key)
*            iii. SST_AuthenticationOpen.
*    13. Close the transaction by calling: SST_TransactionClose.
*    14. Open a transaction by calling: SST_TransactionStart.
*    15. Insert a new data object by calling: SST_InsertData with the Public key authenticator as master authenticator with session id#1.
*    16. Bind the password authenticator to the data object with read only permissions by calling: SST_BindAuthenticatorToElement using session id#1.
*    17. Bind the AES shared key authenticator to the data object with read/write permissions by calling: SST_BindAuthenticatorToElement using session id#1.
*    18. Close all the authenticators (one by one) by calling: SST_AuthenticationClose.
*    19. Close the transaction by calling: SST_TransactionClose.
*    20. Open the password authenticator by calling: SST_AuthenticationOpen. using session id#2
*    21. Open a transaction by calling: SST_TransactionStart.
*    22. Using session id#2 read and compare the data by calling: SST_ReadData. 
*    23. Using session id#2 try to modify the data by calling: SST_ModifyData. (This should fail!)
*    24. Try to bind the AES shared key authenticator to the data by calling: SST_BindAuthenticatorToElement. (This should fail!).
*    25. Close the authenticator by calling: SST_AuthenticationClose.
*    26. Using session #3 open the AES shared key authenticator by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_AES (Encrypt the challenge using the AES key)
*            iii. SST_AuthenticationOpen.
*    27. Close the transaction by calling: SST_TransactionClose.
*    28. Open a transaction by calling: SST_TransactionStart.
*    29. Modify the data from selected location by calling: SST_ModifyData.
*    30. Close the transaction by calling: SST_TransactionClose.
*    31. Using session #3 open the password authenticator by calling: SST_AuthenticationOpen.
*    32. Open a transaction by calling: SST_TransactionStart.
*    33. Using session #3 bind the password authenticator to the data by calling: SST_BindAuthenticatorToElement. (This should fail!).
*    34. Using session #3 read and compare the modified data by calling: SST_ReadData.
*    35. Using session #3 get the data size and compare to known by calling: SST_GetDataSize.
*    36. Open the public key authenticator with session id#1 by calling:
*           i.   SST_AuthenticatorChallengeGet 
*           ii.  CRYS_RSA_PSS_Sign
*           iii. SST_AuthenticationOpen.
*    37. Close the transaction by calling: SST_TransactionClose.
*    38. Open a transaction by calling: SST_TransactionStart.
*    39. Unbind the data from all other authenticators by calling: SST_AuthenticatorUnbind
*    40. Using session #1 and the master authenticator delete the data by calling: SST_DeleteData.
*    41. Close all of the authenticators (one at a time) by calling: SST_AuthenticationClose.
*    42. Delete all of the authenticators (one at a time) by calling: SST_AuthenticatorDelete.
*    43. Close the transaction by calling: SST_TransactionClose.
*    44. Delete all of the sessions (one at a time) by calling: SST_SessionDelete.
*******************************************************************************/
DxError_t SEPQA_SST_BindingWritingPermissions ( void )
{
    /********* TST Variables Definitions ************/
    DxUint32_t                         TST_index=0;
    DxUint32_t                         TST_Error = 0;
    DxUint32_t                         TST_Status = 0;
    DxChar                             TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_BindingWritingPermissions";
    SSTSessionId_t                     TST_SessionId1,TST_SessionId2,TST_SessionId3; 
    SSTTxnId_t                         TST_TransactionId;
    SSTHandle_t                        TST_AuthHandlePwd,TST_AuthHandleAES,TST_AuthHandlePub;
    SSTHandle_t                        TST_DataHandle;
    SSTDataType_t                      TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t                         TST_TempDataSize,TST_OutputDataSize;
    SSTChallengeId_t                   TST_ChallengeId;
    CRYS_RSAUserPrivKey_t*             TST_CRYS_RSAUserPrivKey;
    CRYS_RSAPrivUserContext_t*         TST_CRYS_RSAPrivUserContext;
    SSTHandle_t                        TST_AuthDefaultHandle;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_AuthHandlePwd.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_AuthHandleAES.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_AuthHandlePub.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****** SEPQA_SST_BindingWritingPermissions Test ****** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));

    /*Allocate buffers*/

    /* allocate buffer from GlobalMemBuff for TST_CRYS_RSAUserPrivKey*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAUserPrivKey_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_CRYS_RSAUserPrivKey = (CRYS_RSAUserPrivKey_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_CRYS_RSAUserPrivKey allocation",
                             "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(CRYS_RSAUserPrivKey_t);


    /* allocate buffer from GlobalMemBuff for TST_CRYS_RSAPrivUserContext*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_CRYS_RSAPrivUserContext = (CRYS_RSAPrivUserContext_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_CRYS_RSAPrivUserContext allocation",
                             "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t);


    /* Build the Private Key for CRYS usage */
    /*--------------------------------------*/
    TST_Status = CRYS_RSA_Build_PrivKey(TST_CRYS_RSAUserPrivKey,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_D,
                                        (DxUint16_t)TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DSizeInBytes,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_E,
                                        (DxUint16_t)TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ESizeInBytes,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_N,
                                        (DxUint16_t)TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_NSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_Build_PrivKey",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);

    /* Create a session #1 for operations */
    /*------------------------------------*/
    TST_Error = SST_SessionCreate(&TST_SessionId1);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);

    /* Create a session #2 for operations */
    /*------------------------------------*/
    TST_Error = SST_SessionCreate(&TST_SessionId2);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                                  "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Create a session #3 for operations */
    /*------------------------------------*/
    TST_Error = SST_SessionCreate(&TST_SessionId3);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Error = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Create a new password authenticator using session 1 */
    /*-----------------------------------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                 TST_SessionId1,
                                                 TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Password,
                                                 TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_PasswordSizeInBytes,
                                                 TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_MaxNumOfTrials,
                                                 TST_AuthDefaultHandle,
                                                 &TST_AuthHandlePwd,
                                                 TST_Workspace,
                                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Create a new symmetric key authenticator */
    /*------------------------------------------*/
    TST_Status = SST_AuthenticatorAESSharedSecretCreate(TST_TransactionId,
                                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_AesKey,
                                                        SST_KEY_TYPE_AES_128_BIT,
                                                        &TST_AuthHandleAES,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorAESSharedSecretCreate",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Create a new public key authenticator */
    /*---------------------------------------*/
    TST_Status = SST_AuthenticatorPubKeyRSACreate(TST_TransactionId,
                                                  TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_N,
                                                  TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_E,
                                                  TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ESizeInBytes,
                                                  &TST_AuthHandlePub,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPubKeyRSACreate",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open the public key authentication using session 1 */
    /*----------------------------------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Sign the Challenge buffer */
    TST_Status = CRYS_RSA_PSS_Sign(TST_CRYS_RSAPrivUserContext,
                                   TST_CRYS_RSAUserPrivKey,
                                   CRYS_RSA_HASH_SHA1_mode,
                                   CRYS_PKCS1_MGF1,
                                   20,
                                   TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                                   TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,
                                   TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuff,
                                   (DxUint16_t*)&TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuffSize);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_PSS_Sign",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);




    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId1,
                                        TST_AuthHandlePub,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuff,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open the AES key authentication using session 1 */
    /*-------------------------------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Encrypt the challenge using the AES key */
    TST_Status = CRYS_AES(DX_NULL,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_AesKey,
                          CRYS_AES_Key128BitSize,
                          CRYS_AES_Encrypt,
                          CRYS_AES_ECB_mode,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_EncChallengeBuff);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId1,
                                        TST_AuthHandleAES,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_EncChallengeBuff,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open the password authentication using session 1 */
    /*--------------------------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId1,
                                        TST_AuthHandlePwd,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Password,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);               



    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Insert a new Data object with pub key authentication and session 1 */
    /*--------------------------------------------------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                                TST_SessionId1,
                                TST_AuthHandlePub,
                                TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Data,
                                TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize,
                                DX_TRUE,
                                TST_SimpleData,
                                &TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /*Bind the data object to password authentication with read only permissions */
    /*---------------------------------------------------------------------------*/
    TST_Status = SST_AuthenticatorBind(TST_TransactionId,
                                       TST_SessionId1,
                                       TST_DataHandle,
                                       TST_AuthHandlePwd,
                                       SST_PERMISSION_READ_ONLY,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorBind",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /*Bind the data object to AES key authentication with modify permissions */
    /*-----------------------------------------------------------------------*/
    TST_Status = SST_AuthenticatorBind(TST_TransactionId,
                                       TST_SessionId1,
                                       TST_DataHandle,
                                       TST_AuthHandleAES,
                                       SST_PERMISSION_MODIFY,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorBind",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Close all authenticators */
    /*--------------------------*/
    /* AES shared secret*/
    TST_Status = SST_AuthenticationClose(TST_SessionId1,TST_AuthHandleAES);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /*Password*/
    TST_Status = SST_AuthenticationClose(TST_SessionId1,TST_AuthHandlePwd);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Public key*/
    TST_Status = SST_AuthenticationClose(TST_SessionId1,TST_AuthHandlePub);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open the password authentication using session 2 */
    /*--------------------------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId2,
                                        TST_AuthHandlePwd,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Password,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Read and compare the data using session 2 */
    /*-------------------------------------------*/
    TST_TempDataSize = TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId2,
                              TST_DataHandle,
                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Compare the retrieved data to the original */
    if(!DX_VOS_MemCmp(TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Data,
                      TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_OutputData,
                      TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                                   "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Try to modify the data using session 2 */
    /* !!! THIS SHOULD FAIL !!!               */
    /*----------------------------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                                TST_SessionId2,
                                TST_DataHandle,
                                TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Data,
                                TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize,
                                TST_NO_OFFSET,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);


    TST_Status = TST_CheckExpectedErrorReturn(TST_Status,
                                              SST_RC_ERROR_ACCESS_DENIED,
                                              "SST_DataModify",
                                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Name,
                                              TST_MasterTestName);

    #if SST_TST_EXIT_ON_ERROR
        if(TST_Status != TESTPASS)
            goto EXIT_ON_ERROR;
    #endif

    /* Bind the AES shared authenticator to the data */
    /* !!! THIS SHOULD FAIL!!!!                      */
    /*-----------------------------------------------*/
    TST_Status = SST_AuthenticatorBind(TST_TransactionId,
                                       TST_SessionId2,
                                       TST_DataHandle,
                                       TST_AuthHandleAES,
                                       SST_PERMISSION_MODIFY,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);



    TST_Status = TST_CheckExpectedErrorReturn(TST_Status, 
                                              SST_RC_ERROR_ACCESS_DENIED,
                                              "SST_AuthenticatorBind",
                                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Name,
                                              TST_MasterTestName);

    #if SST_TST_EXIT_ON_ERROR
        if (TST_Status != TESTPASS)
            goto EXIT_ON_ERROR;
    #endif

    /* Close the password authentication */
    /*-----------------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId2,TST_AuthHandlePwd);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open the AES key authentication using session 3 */
    /*-------------------------------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Encrypt the challenge using the AES key */
    TST_Status = CRYS_AES(DX_NULL,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_AesKey,
                          CRYS_AES_Key128BitSize,
                          CRYS_AES_Encrypt,
                          CRYS_AES_ECB_mode,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,
                          TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_EncChallengeBuff);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId3,
                                        TST_AuthHandleAES,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_EncChallengeBuff,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Try to modify the data using session 3 */
    /*----------------------------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                                TST_SessionId3,
                                TST_DataHandle,
                                TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Data,
                                TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize,
                                TST_NO_OFFSET,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataModify",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open the password authentication using session 2 */
    /*--------------------------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId2,
                                        TST_AuthHandlePwd,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Password,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Bind the password authenticator to the data */
    /* !!! THIS SHOULD FAIL!!!!                    */
    /*---------------------------------------------*/
    TST_Status= SST_AuthenticatorBind(TST_TransactionId,
                                      TST_SessionId3,
                                      TST_DataHandle,
                                      TST_AuthHandleAES,
                                      SST_PERMISSION_MODIFY,
                                      TST_Workspace,
                                      TST_WorkspaceSizeInBytes);

    TST_Status = TST_CheckExpectedErrorReturn(TST_Status,
                                              SST_RC_ERROR_ACCESS_DENIED,
                                              "SST_AuthenticatorBind",
                                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Name,
                                              TST_MasterTestName);


    #if SST_TST_EXIT_ON_ERROR
        if (TST_Status != TESTPASS)
            goto EXIT_ON_ERROR;
    #endif

    /* Read and compare the data using session 2 */
    /*-------------------------------------------*/
    TST_TempDataSize = TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId2,
                              TST_DataHandle,
                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Compare the retrieved data to the original */
    if(!DX_VOS_MemCmp(TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_Data,
                      TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_OutputData,
                      TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);

    /* Get Data Size and compare */
    /*---------------------------*/
    TST_Status = SST_DataSizeGet(TST_SessionId2,
                                 TST_DataHandle,
                                 &TST_OutputDataSize,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataSizeGet",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);



    /* Open the public key authentication using session 1 */
    /*----------------------------------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Sign the Challenge buffer */
    TST_Status = CRYS_RSA_PSS_Sign(TST_CRYS_RSAPrivUserContext,
                                   TST_CRYS_RSAUserPrivKey,
                                   CRYS_RSA_HASH_SHA1_mode,
                                   CRYS_PKCS1_MGF1,
                                   20,
                                   TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuff,
                                   TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_ChallengeBuffSize,
                                   TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuff,
                                   (DxUint16_t*)&TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuffSize);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_PSS_Sign",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId1,
                                        TST_AuthHandlePub,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuff,
                                        TST_ATP_BindingWritingPermissionsTestData[TST_index].TST_SignedChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                                  "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);

    /* Unbind the data from all other authenticators */
    /*-----------------------------------------------*/
    /* Unbind from AES authenticator*/
    TST_Status = SST_AuthenticatorUnbind(TST_TransactionId,
                                        TST_SessionId1,
                                        TST_DataHandle,
                                        TST_AuthHandleAES,
                                        SST_PERMISSION_MODIFY,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorUnbind",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Unbind from password authenticator*/
    TST_Status = SST_AuthenticatorUnbind(TST_TransactionId,
                                         TST_SessionId1,
                                         TST_DataHandle,
                                         TST_AuthHandlePwd,
                                         SST_PERMISSION_READ_ONLY,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorUnbind",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Delete the data using session 1 */
    /*---------------------------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId1,
                                TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Close all authenticators */
    /*--------------------------*/
    /* AES shared secret*/
    TST_Status = SST_AuthenticationClose(TST_SessionId3,TST_AuthHandleAES);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose-TST_AuthHandleAES",
                                  "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /*Password on session 2*/
    TST_Status = SST_AuthenticationClose(TST_SessionId2,TST_AuthHandlePwd);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose-TST_AuthHandlePwd - session2",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Public key*/
    TST_Status = SST_AuthenticationClose(TST_SessionId1,TST_AuthHandlePub);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose-TST_AuthHandlePub",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Delete the authenticators */
    /*---------------------------*/
    /* Password */
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandlePwd);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - password",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* AES shared secret */
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandleAES);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - AES",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Public key */
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandlePub);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - Public key",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    /* Delete all the sessions */
    /*-------------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId1);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete1",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    TST_Status = SST_SessionDelete(TST_SessionId2);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete2",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


    TST_Status = SST_SessionDelete(TST_SessionId3);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete3",
                               "SEPQA_SST_BindingWritingPermissions",TST_MasterTestName);


  EXIT_ON_ERROR:
    return TST_Status;
}/* End of SEPQA_SST_BindingWritingPermissions */